% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutoffSensitivityPlot.R
\name{cutoffSensitivityPlot}
\alias{cutoffSensitivityPlot}
\title{Plot a sensitivity plot for cutoff values}
\usage{
cutoffSensitivityPlot(predTest, depTest, metric = c("accuracy",
  "expMisclassCost", "misclassCost"), costType = c("costRatio", "costMatrix",
  "costVector"), costs = NULL, resolution = 1/50)
}
\arguments{
\item{predTest}{Vector with predictions (real-valued or discrete)}

\item{depTest}{Vector with true class labels}

\item{metric}{Which metric to assess. Should be one of the following values:
\code{"accuracy"}, \code{"misclassCost"} or \code{"expMisclassCost"}.}

\item{costType}{An argument that specifies how the cost information is provided.
This should be either \code{"costRatio"} or \code{"costMatrix"} when \code{metric}
equals \code{"expMisclassCost"}; or \code{"costRatio"}, \code{"costVector"} or
\code{"costMatrix"} when \code{metric} equals \code{"MisclassCost"}. In the former
case, a single value is provided which reflects the cost ratio (the ratio of the cost
associated with a false negative to the cost associated with a false positive). In the
latter case, a full (4x4) misclassification cost matrix should be provided in the form
\code{rbind(c(0,3),c(15,0))} where in this example 3 is the cost for a false positive,
and 15 the cost for a false negative case.}

\item{costs}{see \code{costType}}

\item{resolution}{Value for the determination of percentile intervals. Default 1/10 (10\%).}
}
\description{
Visualize the sensitivity of a chosen metric to the choice of the threshold (cutoff) value
used to transform continuous predictions into class predictions.
}
\examples{
## Load response modeling predictions
data("response")
## Apply cutoffSensitivityPlot function to visualize how the cutoff value influences
## accuracy.
cutoffSensitivityPlot(response$test[,2],response$test[,1],metric="accuracy")
## Same exercise, but in function of misclassification costs
costs <- runif(nrow(response$test), 1, 50)
cutoffSensitivityPlot(response$test[,2],response$test[,1],metric="misclassCost",
costType="costVector",costs=costs, resolution=1/10)

}
\seealso{
\code{\link{dynAccuracy}}, \code{\link{misclassCost}}, \code{\link{expMisclassCost}}
}
\author{
Koen W. De Bock, \email{kdebock@audencia.com}
}
