% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_cure.R
\name{summary_cure}
\alias{summary_cure}
\title{Print the summary output}
\usage{
summary_cure(object, ...)
}
\arguments{
\item{object}{an object of the class "dcensoring".}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a summary of the fitted model.
}
\description{
Print the summary output
}
\examples{
\donttest{
library(CureDepCens)

delta_t = ifelse(Dogs_MimicData$cens==1,1,0)
delta_c = ifelse(Dogs_MimicData$cens==2,1,0)

fit <- cure_dep_censoring(formula = time ~ x1_cure + x2_cure | x_c1 + x_c2,
                          data = Dogs_MimicData,
                          delta_t = delta_t,
                          delta_c = delta_c,
                          ident = Dogs_MimicData$ident,
                          dist = "mep")
summary_cure(fit)
}
}
