/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;

public class ClassConfig {
    protected static Log logger = LogFactory.getLog(ClassConfig.class);
    private Configuration conf;
    private Class c;

    public ClassConfig(Configuration conf, Class c) {
        this.conf = conf;
        this.c = c;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getProperty(String prop) {
        return this.getConf().getClassProperty(this.c, prop);
    }

    public String getProperty(String prop, String def) {
        return this.getConf().getClassProperty(this.c, prop, def);
    }

    public void setProperty(String prop, String val) {
        this.getConf().setClassProperty(this.c, prop, val);
    }

    public int getIntProperty(String prop, int def) {
        return Integer.parseInt(this.getConf().getClassProperty(this.c, prop, "" + def));
    }

    public double getDoubleProperty(String prop, double def) {
        return Double.parseDouble(this.getConf().getClassProperty(this.c, prop, "" + def));
    }

    public boolean getBoolProperty(String prop, boolean def) {
        return Boolean.parseBoolean(this.getConf().getClassProperty(this.c, prop, "" + def));
    }

    public void setIntProperty(String prop, int val) {
        this.setProperty(prop, "" + val);
    }

    public void setDoubleProperty(String prop, double val) {
        this.setProperty(prop, "" + val);
    }

    public void setBoolProperty(String prop, boolean val) {
        this.setProperty(prop, "" + val);
    }
}

