% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_regression_estimator.R
\name{dct_1d}
\alias{dct_1d}
\title{Compute 1D Discrete Cosine Transform}
\usage{
dct_1d(X)
}
\arguments{
\item{X}{A vector of values for which the discrete cosine transform is being computed.}
}
\value{
A vector of discrete cosine transform values.
}
\description{
This function computes the Type-II discrete cosine transform.
}
\details{
The Type-II discrete cosine transform is obtained using \link[stats:fft]{stats::fft}.
If \eqn{X} is of length N, construct a new signal \eqn{Y} of length \eqn{4N}, with values \eqn{Y_{2n} = 0, Y_{2n + 1} = x_{n}} for \eqn{0 \le n < N},
and \eqn{Y_{2N} = 0, Y_{4N - n} = y_{n}} for \eqn{0 < n < 2N.}
After this, the Type-II discrete cosine transform is computed by \code{0.5 * Re(stats::fft(Y))[1:(length(Y) / 4)]}.
}
\examples{
X <- c(1, 2, 3)
dct_1d(X)
}
\references{
Ochoa-Dominguez, H. & Rao, K.R. (2019). Discrete Cosine Transform, Second Edition. CRC Press. https://doi.org/10.1201/9780203729854

Makhoul, J. (1980). A Fast Cosine Transform in One and Two Dimensions. IEEE Transactions on Acoustics, Speech, and Signal Processing 28(1), 27-34. https://doi.org/10.1109/TASSP.1980.1163351

Stasiński, R. (2002). DCT Computation Using Real-Valued DFT Algorithms. Proceedings of the 11th European Signal Processing Conference.
}
