% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMData.R
\name{multinom.gen}
\alias{multinom.gen}
\alias{mg.Resample}
\alias{mg.DirMult}
\alias{mg.LogitNorm}
\alias{mg.MixMult}
\title{Functions for generating multinomial outcomes}
\usage{
mg.Resample(n, clustersizes, param)

mg.DirMult(n, clustersizes, param)

mg.LogitNorm(n, clustersizes, param)

mg.MixMult(n, clustersizes, param)
}
\arguments{
\item{n}{number of independent clusters to generate}

\item{clustersizes}{an integer vector specifying the sizes of the clusters}

\item{param}{a list of parameters for each specific generator}
}
\description{
These are built-in functions to be used by \code{\link{ran.CMData}} for generating
random multinomial data.
}
\details{
For \bold{mg.Resample}: the \code{param} list should be \code{list(param=...)}, in which
the CMData object to be resampled is passed.

For \bold{mg.DirMult}: the \code{param} list should be \code{list(shape=...)}, in which
the parameter vector of the Dirichlet distribution is passed 
(see \link[dirmult]{rdirichlet}).

For \bold{mg.LogitNorm}: the \code{param} list should be \code{list(mu=...,sigma=...)}, 
in which the mean vector and covariance matrix of the underlying Normal distribution 
are passed. If \code{sigma} is NULL (or missing), then an identity matrix is assumed.
They should have \emph{K-1} dimensions for a \emph{K}-variate multinomial.

For \bold{mg.MixMult}: the \code{param} list should be \code{list(q=...,m=...)}, 
in which the vector of mixture probabilities \code{q} and the matrix \code{m}
of logit-transformed means of each component are passed.
For a \emph{K}-variate multinomial, the matrix \code{m} should have \emph{K-1} columns
and \code{length(q)} rows.
}
