% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hncs.R
\name{hncs}
\alias{hncs}
\title{Conditional distribution of non-central squared copula}
\usage{
hncs(data, cond_var, family, rotation = 0, par)
}
\arguments{
\item{data}{Matrix (x,y) of size n x 2}

\item{cond_var}{Conditioning variable (1 or 2)}

\item{family}{Copula family: "ncs-gaussian", "ncs-clayton", "ncs-frank", "ncs-gumbel", "ncs-joe", "ncs-plackett''.}

\item{rotation}{Rotation: 0 (default value), 90, 180, or 270.}

\item{par}{vector of copula parameter  and non-centrality parameter a1,a2 >0}
}
\value{
\item{h}{Conditional  cdf}
}
\description{
This function computes the conditional distribution of the  non-central squared copula (ncs)  associated with a one-parameter copula with parameter cpar, and parameters a1, a2 >0 .
}
\examples{
hncs(c(0.5,0.8),1,"ncs-clayton",270,c(2,1,2))


}
\references{
Nasri (2020). On non-central squared copulas. Statistics and Probability Letters.
}
