% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertySuperadditivity.R
\name{isSuperadditiveGame}
\alias{isSuperadditiveGame}
\alias{isSuperAdditiveGame}
\title{Check if game is superadditive}
\usage{
isSuperadditiveGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is superadditive, else \code{FALSE}.
}
\description{
Checks if a TU game with n players is superadditive. \cr
In a superadditive game for any two disjoint coalitions 
\code{S} and \code{T} the value of the union of 
\code{S} and \code{T} is always greater or equal 
the sum of the values of \code{S} and \code{T}. 
In other words, the members of any two disjoint 
coalitions \code{S} and \code{T} will never be 
discouraged from collaborating.
}
\examples{
library(CoopGame)
isSuperadditiveGame(c(0,0,0,1,1,1,2))

\donttest{
#Example of a superadditive game
library(CoopGame)
v1=c(0,0,0,40,50,20,100) 
isSuperadditiveGame(v1)

#Example of a game that is not superadditive 
library(CoopGame)
v2=c(0,0,0,40,30,130,100) 
isSuperadditiveGame(v2)

#Another example of a superadditive game
library(CoopGame)
v3=c(1,1,1,1, 2,2,2,2,2,2, 3,3,3,3, 4)
isSuperadditiveGame(v3)
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 10

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, p. 295

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 671

Narahari Y. (2015)  \emph{Game Theory and Mechanism Design}, World Scientific Publishing, p. 408
}
\author{
Alexandra Tiukkel

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
