% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getUtopiaPayoff.R
\name{getUtopiaPayoff}
\alias{getUtopiaPayoff}
\alias{getUtopiaPayoffVector}
\title{Compute utopia payoff vector of game}
\usage{
getUtopiaPayoff(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
utopia payoffs for each player
}
\description{
getUtopiaPayoff calculates the utopia payoff vector for 
each player in a TU game. \cr
The utopia payoff of player i is the marginal contribution 
of player i to the grand coalition.
}
\examples{
library(CoopGame)
maschlerGame <- c(0,0,0,60,60,60,72)
getUtopiaPayoff(maschlerGame)

}
\references{
Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 31
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Michael Maerz

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
