% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ColemanPreventiveConcept.R
\name{colemanPreventivePowerIndex}
\alias{colemanPreventivePowerIndex}
\title{Compute Coleman Preventive Power index}
\usage{
colemanPreventivePowerIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Coleman Preventive Power index for specified simple game
}
\description{
Calculates the Coleman Preventive Power index for a specified simple TU game.
Note that in general the Coleman Preventive Power index is not an efficient vector, 
i.e. the sum of its entries is not always 1.
Hence no drawing routine for the Coleman Preventive Power index is provided.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
colemanPreventivePowerIndex(v) 

}
\references{
Coleman J.S. (1971) "Control of collectivities and the power of a collectivity to act". In: Liberman B. (Ed.), Social Choice, Gordon and Breach, pp. 269--300

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 120--123

De Keijzer B. (2008) "A survey on the computation of power indices", Technical Report, Delft University of Technology, p. 18

Bertini C. and Stach I. (2011) "Coleman index", Encyclopedia of Power, SAGE Publications, p. 117--119
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
