% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CardinalityGame.R
\name{cardinalityGame}
\alias{cardinalityGame}
\title{Construct a cardinality game}
\usage{
cardinalityGame(n)
}
\arguments{
\item{n}{represents the number of players}
}
\value{
A list with two elements 
representing the cardinality game (n, Game vector v)
}
\description{
\strong{Create a list containing 
all information about a specified cardinality game:} \cr
For a cardinality game the worth of each coalition 
is simply the number of the members of the coalition.
}
\section{Related Functions}{
 
\link{cardinalityGameValue}, \link{cardinalityGameVector}
}

\examples{
library(CoopGame)
cardinalityGame(n=3)

\donttest{
library(CoopGame)
#Example: Cardinality function for four players
(vv<-cardinalityGame(n=4))
#$n
#[1] 4

#$v
#[1] 1 1 1 1 2 2 2 2 2 2 3 3 3 3 4
}

}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
