% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaruaChakravartySarkarConcept.R
\name{baruaChakravartySarkarIndex}
\alias{baruaChakravartySarkarIndex}
\title{Compute Barua Chakravarty Sarkar index}
\usage{
baruaChakravartySarkarIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Barua Chakravarty Sarkar index for specified simple game
}
\description{
Calculates the Barua Chakravarty Sarkar index for a specified simple TU game.
Note that in general the Barua Chakravarty Sarkar index is not an efficient vector, 
i.e. the sum of its entries is not always 1.
Hence no drawing routine for the Barua Chakravarty Sarkar index is provided.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
baruaChakravartySarkarIndex(v) 

}
\references{
Barua R., Chakravarty S.R. and Sarkar P. (2012) "Measuring p-power of voting", Journal of Economic Theory and Social Development 1(1), pp. 81--91

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 120--123
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
