% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_data_generators.R
\name{test_data}
\alias{test_data}
\title{Test data generator}
\usage{
test_data(
  amplitude = 1,
  f = 100,
  npoints = 1000,
  type = "sinusoidal",
  x0 = 0,
  noise_contribution = 100
)
}
\arguments{
\item{amplitude}{amplitude of the signal, default = 1}

\item{f}{frequency of the sinusoidal signal, default = 100}

\item{npoints}{number of points of the time serie}

\item{type}{type of signal, default = sinusoidal. Available types: sinusoidal, gaussian}

\item{x0}{signal position for gaussian type. Default = 0}

\item{noise_contribution}{percentage pointing the maximum wanted signal/noise ratio. Default = 10}
}
\value{
A time serie with added random noise.
}
\description{
Generate test data in order to test the filtering functions.
To a signal function is added random noise contribution.
V0.1 = noise is assumed gaussian
}
\examples{
test_data()

}
