% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfcp.R
\name{vfcp.fun}
\alias{vfcp.fun}
\title{Validity first conformal prediction for ridge regression}
\usage{
vfcp.fun(X, Y, X0, lambda = seq(0, 100, length = 100), alpha = 0.1)
}
\arguments{
\item{X}{A N*d training matrix}

\item{Y}{A N*1 training vector}

\item{X0}{A N0*d testing vector}

\item{lambda}{a sequence of penalty parameters for ridge regression}

\item{alpha}{miscoverage level}
}
\value{
upper and lower prediction intervals for X0.
}
\description{
Validity first conformal prediction for ridge regression
}
\examples{
df=3
d = 5
n=50   #number of training samples
n0=10  #number of prediction points
rho=0.5
Sigma=matrix(rho,d,d)
diag(Sigma)=rep(1,d)
beta=rep(1:5,d/5)
X0=mvtnorm::rmvt(n0,Sigma,df)
X=mvtnorm::rmvt(n,Sigma,df)	#multivariate t distribution
eps=rt(n,df)*(1+sqrt(X[,1]^2+X[,2]^2))
Y=X\%*\%beta+eps
out.vfcp=vfcp.fun(X,Y,X0)
out.vfcp$up
out.vfcp$lo
}
