% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alternate.R
\name{alternate}
\alias{alternate}
\alias{alternate_model}
\title{Run parameter variation}
\usage{
alternate(
  x,
  f,
  run_map,
  return_raw = TRUE,
  error_funs = NULL,
  error_args = NULL
)

alternate_model(run_map, x, f)
}
\arguments{
\item{x}{A cfp_pfres or cfp_fgres model result.}

\item{f}{A function taking in a soilphys object and recalculates the relevant
columns. See \code{\link[=complete_soilphys]{complete_soilphys()}}.}

\item{run_map}{A data.frame created by \code{\link[=run_map]{run_map()}} with the necessary
information how the data is to be changed with each distinct \code{run_id}.}

\item{return_raw}{Should the models be returned as is, or after applying any
\code{error_funs}. Default is \code{TRUE} - exporting the models.}

\item{error_funs}{A list of functions to be applied after flux calculation if
\code{return_raw == FALSE}. This can be used to output not the models but
quality parameters instead. Output must contain the column RMSE.}

\item{error_args}{A list of additional function arguments to be passed to any
of the \code{error_funs}. Must match the length of \code{error_funs}}
}
\value{
A \code{list} of type \code{\link[=cfp_altres]{cfp_altres()}}, each entry an
updated model.
}
\description{
Alternate \code{\link[=cfp_pfres]{cfp_pfres()}} / \code{\link[=cfp_fgres]{cfp_fgres()}} models for sensitivity analysis
and more.
}
\details{
\code{\link[=alternate_model]{alternate_model()}} is used internally to change and rerun one
model, but can also be used to update a model with a given unique run_map,
e.g. by filtering the best run_id from the original \code{run_map}.
}
\examples{
PROFLUX <- ConFluxPro::base_dat |>
  filter(site == "site_a") |> # use only 'site_a' for example
  pro_flux()

# Create a cfp_run_map where TPS is changed between 90 \% and 110 \%
# of the original value for 2 runs.
my_run_map <-
cfp_run_map(
  PROFLUX,
  list("TPS" = c(0.9, 1.1)),
  "factor",
  n_runs = 2)

# run the new models by providing a function `f`
# that updates the soilphys data.frame.
alternate(
  x = PROFLUX,
  f = \(x) complete_soilphys(x, "a+AFPS^b", quiet = TRUE),
  run_map = my_run_map)

}
