% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcomppareto.R
\name{pcomppareto}
\alias{pcomppareto}
\title{The cumulative distribution function (CDF) of a composite distribution with Pareto tail}
\usage{
pcomppareto(
  x,
  spec,
  alpha = 1,
  theta = 1,
  lower.tail = TRUE,
  log.p = FALSE,
  ...
)
}
\arguments{
\item{x}{A scalar or vector of positive values at which the CDF needs to be evaluated}

\item{spec}{The selection of the lower tail (head) distribution}

\item{alpha}{The shape parameter of the Pareto distribution}

\item{theta}{The scale parameter of Pareto, also serve as the location parameter of the composite model}

\item{lower.tail}{logical; if FALSE, the upper tail probability is provided}

\item{log.p}{logical; if TRUE, probability p are given as log(p)}

\item{...}{The parameter of the lower tail (head) distribution}
}
\value{
an object of the same length of x as the CDF evaluated at x
}
\description{
\code{pcomppareto} returns the CDF of a composite distribution with a Pareto upper tail at x, with a specified distribution at the lower tail.
}
\examples{
x<-1:100
pcomppareto(x, "lnorm", 0.4, 1, meanlog = 1, sdlog = 0.8)
pcomppareto(x, "weibull", alpha = 1.5, theta = 1.5, shape = 2, scale = 2)
}
