% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gram.R
\name{gram}
\alias{gram}
\title{The Gramacy et. al 2016 test function}
\usage{
gram(x1, x2)
}
\arguments{
\item{x1}{A scalar value between 0 and 1, inclusive}

\item{x2}{A scalar value between 0 and 1, inclusive}
}
\value{
The evaluation of running the Gramacy et. al 2016 test function at input (x1, x2).
\itemize{
  \item obj:  A scalar objective function value
  \item con:  A vector of constraint function values
}
}
\description{
The computer model test function introduced in Gramacy et. al 2016.
}
\note{
A solution is feasible only if of all of the constraint functions values are less than or equal to 0.
}
\examples{
### Running the function at x1 = 0.2 and x2 = 0.2
### obj = 0.4 and con = (1.29,-1.42)
### (x1,x2) = (0.2,0.2) is not a feasible solution

gram(0.2,0.2)
}
\references{
Gramacy, R.B., Gray, G.A., Digabel, S.L., Lee, H.K.H., Ranjan, P., Wells, G., and Wild, S.M. (2016). Modeling an augmented Lagrangian for blackbox constrained optimization. Technometrics, 58(1):1-11.
}
