% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Help_Func.R
\name{eb_check}
\alias{eb_check}
\title{EB Assumption Check}
\usage{
eb_check(
  data,
  bat,
  covar = NULL,
  model = lm,
  formula = NULL,
  robust.LS = FALSE,
  ref.batch = NULL,
  ...
)
}
\arguments{
\item{data}{\emph{n x p} data frame or matrix of observations where
\emph{p} is the number of features and \emph{n} is the number of subjects.}

\item{bat}{Factor indicating batch (often equivalent to site or scanner).}

\item{covar}{Data frame or matrix of covariates supplied to \code{model}.}

\item{model}{The model function that ComBat Family supports: \code{lm}, \code{lmer}, \code{gam}.}

\item{formula}{Formula for \code{model} starting with \verb{y ~} where \code{y} represents each feature.}

\item{robust.LS}{If \code{TRUE}, uses robust location and scale estimators for error variance and site effect parameters. Currently uses median and
biweight midvariance.}

\item{ref.batch}{Reference batch, must take value in \code{levels(bat)}.}

\item{...}{Additional arguments to \code{model}.}
}
\value{
\code{eb_check} returns a dataframe containing the empirical and prior distribution of both the location parameter (gamma) and the scale parameter (delta).
}
\description{
Generate the empirical and prior distribution of both the location parameter \code{gamma} and the scale parameter \code{delta}.
}
\examples{
eb_check(data = adni[1:500,43:53], bat = as.factor(adni$manufac[1:500]),
covar = adni[1:500, c("AGE", "SEX")], model = lm, formula = y ~ AGE + SEX)

}
