% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoDaImpact-package.R
\docType{data}
\name{election}
\alias{election}
\title{Results of french departmental elections in 2015}
\format{
An object of class \code{data.frame} with 95 rows and 13 columns.
}
\source{
\itemize{
\item https://www.data.gouv.fr/fr/datasets/elections-departementales-2015-resultats-par-bureaux-de-vote
\item https://www.insee.fr/fr/accueil
}
}
\usage{
election
}
\description{
The data is used by Nguyen et. al (2020) and originally disseminated by the
French ministry (Ministère de l'Intérieur et des Outre-Mer).
Information about the population characteristics comes from the french
national statistics institute (INSEE).
}
\details{
\itemize{
\item \code{left}, \code{right}, \code{extreme_right}: Vote shares during the election grouped into three blocks
\item \code{Age_1839}, \code{Age_4064}, \code{Age_65plus}: Share of the population falling into one of three age categories
\item \code{Educ_BeforeHighschool}, \code{Educ_Highschool}, \code{Educ_Higher}: Share of the population having completed a certain level of education.
\item \code{asset_owner_rate}: The proportion of people who own assets
\item \code{income_taxpayer_rate}: The proportion of people who pay income tax
\item \code{forgeigner_rate}: The proportion of foreigners
}
}
\references{
Nguyen THA, Laurent T, Thomas-Agnan C, Ruiz-Gazen A. Analyzing the impacts of socio-economic factors on French departmental elections with CoDa methods. J Appl Stat. 2020 Dec 9;49(5):1235-1251. doi: 10.1080/02664763.2020.1858274. PMID: 35707505; PMCID: PMC9041641.
}
\author{
Lukas Dargel, Christine Thomas-Agnan
}
\keyword{data}
