% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-lmCoDa.R
\name{ToSimplex}
\alias{ToSimplex}
\title{Converting Linear Models to CoDa models}
\usage{
ToSimplex(object)
}
\arguments{
\item{object}{an object of class "lmCoDa"}
}
\value{
an object of class "lm" and "lmCoDa" if the formula include at least
one log-transformation
}
\description{
The function converts the output of a "lm" to the "lmCoDa" class, which
offers additional tools for the interpretation of a CoDa regression models.
Most of the work is done by the \code{\link[=transformationSummary]{transformationSummary()}} function, which
has its own documentation page, but should be reserved for internal use.
}
\examples{

# XY-compositional model
res <- lm(
  ilr(cbind(left, right, extreme_right)) ~
  ilr(cbind(Educ_BeforeHighschool, Educ_Highschool, Educ_Higher)),
  data =  head(election, 20))
res <- ToSimplex(res)

# X-compositional model
res <- lm(YIELD ~ PRECIPITATION + ilr(TEMPERATURES), data = head(rice_yields, 20))
res <- ToSimplex(res)
}
\seealso{
\code{\link[=lm]{lm()}}, \code{\link[=lmCoDa]{lmCoDa()}}
}
\author{
\itemize{
\item Lukas Dargel
\item Rodrigue Nasr
}
}
