% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClussCluster.R
\name{filter_gene}
\alias{filter_gene}
\title{Gene Filter}
\usage{
filter_gene(dfname, minmean = 2, n0prop = 0.2, minsd = 1)
}
\arguments{
\item{dfname}{name of the expression data frame}

\item{minmean}{minimum mean expression for each gene}

\item{n0prop}{minimum proportion of zero expression (count) for each gene}

\item{minsd}{minimum standard deviation of expression for each gene}
}
\value{
a list containing the data set with genes satisfying the thresholds, \code{dat.ft}, the name of \code{dat.ft}, and the indices of those kept genes, \code{index}.
}
\description{
Filters out genes that are not suitable for differential expression analysis.
}
\details{
Takes an expression data frame that has been properly normalized but NOT centered. It returns a list with the slot \code{dat.ft} being the data set that satisfies the pre-set thresholds on minumum mean, standard deviation (sd), and proportion of zeros (n0prop) for each gene.

If the data has already been centered, one can still apply the filters of \code{mean} and \code{sd} but not \code{n0prop}.
}
\examples{
dat <- matrix(rnbinom(300*60, mu = 2, size = 1), 300, 60)
dat_filtered <- filter_gene(dat, minmean=2, n0prop=0.2, minsd=1)
}
