% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv27_anscombe_ppu.R
\name{cv27_anscombe_ppu}
\alias{cv27_anscombe_ppu}
\title{Process Performance Calculation using Anscombe's Transformation}
\usage{
cv27_anscombe_ppu(data, residue_col, cleaning_event_col, usl_col)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{residue_col}{Name of the column in `data` containing residue or defect counts.}

\item{cleaning_event_col}{Name of the column in `data` used for grouping by cleaning event.}

\item{usl_col}{Name of the column in `data` that contains the Upper Specification Limit (USL).}
}
\value{
A data frame with columns for the Method, Ppu, CI_Lower, and CI_Upper.
}
\description{
Calculates the Process Performance Index (Ppu) using Anscombe's transformation. 
This function also performs a bootstrap to estimate the confidence interval of Ppu.
}
\examples{
cv27_anscombe_ppu(Eq_Mic, "Mic", "CleaningEvent", "USL")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
