% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv22_var_random_effect.R
\name{cv22_var_random_effect}
\alias{cv22_var_random_effect}
\title{Extract Variance of Random Effects}
\usage{
cv22_var_random_effect(data, residue_col, cleaning_event_col)
}
\arguments{
\item{data}{A data frame containing the data.}

\item{residue_col}{The name of the residue column.}

\item{cleaning_event_col}{The name of the column used for random effects grouping.}
}
\value{
A data frame with the variances and standard deviations of the random effects.
}
\description{
This function fits a Poisson mixed-effects model with a specified random effect 
and extracts the variances and standard deviations of the random effects.
}
\examples{
ra_table <- cv22_var_random_effect(data=Eq_Mic, residue_col="Mic", 
cleaning_event_col="CleaningEvent")

}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
