% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv21_poisson_mixed.R
\name{cv21_poisson_mixed}
\alias{cv21_poisson_mixed}
\title{Poisson Mixed Effect Model Summary}
\usage{
cv21_poisson_mixed(data, residue_col, cleaning_event_col)
}
\arguments{
\item{data}{A data frame containing the data set for analysis.}

\item{residue_col}{A string specifying the column in `data` that contains residue data.}

\item{cleaning_event_col}{A string specifying the column in `data` for random effects grouping.}
}
\value{
A data frame with the fixed effect summary of the mixed-effects Poisson regression model.
}
\description{
Fits a mixed-effects Poisson model to the data and returns a data frame containing
the fixed effect part estimates, standard errors, z-values, and p-values.
}
\examples{
# Assuming 'Eq_Mic' is a data frame, 'Mic' is the residue column of interest,
# and 'CleaningEvent' is the column for random effects grouping.
mixed_effect_summary <- cv21_poisson_mixed(data = Eq_Mic, residue_col = "Mic", 
cleaning_event_col = "CleaningEvent")
print(mixed_effect_summary)
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
