% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviationindex.R
\name{deviationindex}
\alias{deviationindex}
\title{Deviation index}
\usage{
deviationindex(E, d, R, S)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{R}{A rule : AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, RTalmud.}

\item{S}{A rule: AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, RTalmud.}
}
\value{
The deviation index and the signed deviation index of a rule for a claims problem.
}
\description{
This function returns the deviation index and the signed deviation index for a rule with respect to another rule.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}.

Rearrange the claims from small to large, \eqn{0 \le d_1 \le...\le d_n}.
The signed deviation index of the rule \eqn{\mathcal{S}} with respect to the rule \eqn{\mathcal{R}} for the problem \eqn{(E,d)}, denoted by \eqn{I(\mathcal{R}(E,d),\mathcal{S}(E,d))}, is
the ratio of the area that lies between the identity line and the cumulative curve over the total area under the identity line.

Let \eqn{\mathcal{R}_0=0} and \eqn{\mathcal{S}_0=0}. For each \eqn{k=1,\dots,n} define
\eqn{X_k=\frac{1}{E} \sum_{j=0}^{k}\mathcal{R}_j} and \eqn{Y_k=\frac{1}{E} \sum_{j=0}^{k} \mathcal{S}_j}. Then,
\deqn{I(\mathcal{R}(E,d),\mathcal{S}(E,d))=1-\sum_{k=1}^{n}\Bigl(X_{k}-X_{k-1}\Bigr)\Bigl(Y_{k}+Y_{k-1}\Bigr).}
 In general  \eqn{-1 \le I(\mathcal{R}(E,d),\mathcal{S}(E,d)) \le 1}.

The deviation index of the rule \eqn{\mathcal{S}} with respect to the rule \eqn{\mathcal{R}} for the problem \eqn{(E,d)}, denoted by \eqn{I^{+}(\mathcal{R}(E,d),\mathcal{S}(E,d))}, is
the ratio of the area between the line of the cumulative sum of the distribution proposed by the rule \eqn{\mathcal{R}} and the cumulative curve over the area under the line \eqn{x=y}.

In general  \eqn{0 \le I^{+}(\mathcal{R}(E,d),\mathcal{S}(E,d)) \le 1}.

The proportionality deviation index is the deviation index when \eqn{\mathcal{R} = \text{PRO}}. The proportionality deviation index of the proportional rule is zero for all claims problems.
The signed proportionality deviation index is the signed deviation index with \eqn{\mathcal{R} = \text{PRO}}.
}
\examples{
E=10
d=c(2,4,7,8)
R=CEA
S=AA
deviationindex(E,d,R,S)
#The deviation index of rule R with respect of the rule R is 0.
deviationindex(E,d,PRO,PRO)
}
\references{
Ceriani, L. and Verme, P. (2012). The origins of the Gini index: extracts from Variabilitá e Mutabilitá (1912) by Corrado Gini. The Journal of Economic Inequality 10(3), 421-443.

Mirás Calvo, M.Á., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez Rodríguez, E. (2023). Deviation from proportionality and Lorenz-domination for claims problems. Review of Economic Design 27, 439-467.
}
\seealso{
\link{allrules}, \link{cumawardscurve}, \link{giniindex}, \link{indexgpath}, \link{lorenzcurve}, \link{lorenzdominance}.
}
