% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_taxonomic_reduction.R
\name{safe_taxonomic_reduction}
\alias{safe_taxonomic_reduction}
\title{Safe Taxonomic Reduction}
\usage{
safe_taxonomic_reduction(cladistic_matrix)
}
\arguments{
\item{cladistic_matrix}{A character-taxon matrix in the format imported by \link{read_nexus_matrix}.}
}
\value{
\item{str_taxa}{A matrix listing the taxa that can be removed (\code{junior}), the taxa which they are equivalent to (\code{senior}) and the rule under which they can be safely removed (\code{rule}).}
\item{reduced_matrix}{A character-taxon matrix excluding the taxa that can be safely removed.}
\item{removed_matrix}{A character-taxon matrix of the taxa that can be safely removed.}
}
\description{
Performs Safe Taxonomic Reduction (STR) on a character-taxon matrix.
}
\details{
Performs Safe Taxonomic Reduction (Wilkinson 1995).

If no taxa can be safely removed will print the text "No taxa can be safely removed", and the \code{str_taxa} and \code{removed_matrix} will have no rows.

NB: If your data contains inapplicable characters these will be treated as missing data, but this is inappropriate. Thus the user is advised to double check that any removed taxa make sense in the light of inapplicable states. (As far as I am aware this same behaviour occurs in the TAXEQ3 software.)
}
\examples{

# Performs STR on the Gauthier 1986 dataset used in Wilkinson (1995):
str_data <- safe_taxonomic_reduction(cladistic_matrix = gauthier_1986)

# View deleted taxa:
str_data$str_taxa

# View reduced matrix:
str_data$reduced_matrix

# View removed matrix:
str_data$removed_matrix
}
\references{
Wilkinson, M., 1995. Coping with abundant missing entries in phylogenetic inference using parsimony. \emph{Systematic Biology}, \bold{44}, 501-514.
}
\seealso{
\link{build_cladistic_matrix}, \link{compactify_cladistic_matrix}, \link{prune_cladistic_matrix}, \link{safe_taxonomic_reinsertion}, \link{read_nexus_matrix}, \link{write_nexus_matrix}, \link{write_tnt_matrix}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
