% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.stateGraph.R
\name{is.stateGraph}
\alias{is.stateGraph}
\title{Stategraph class}
\usage{
is.stateGraph(x)
}
\arguments{
\item{x}{An object of class \code{stateGraph}.}
}
\value{
\code{is.stateGraph} returns either TRUE or FALSE.
}
\description{
Functions to deal with the stategraph class.
}
\details{
Claddis uses various classes to define specific types of data, here the use of a character stategraph (to specify the parsimony costs of transitions between character states) are assigned the class "stateGraph".

\code{is.stateGraph} checks whether an object is or is not a valid stateGraph object.
}
\examples{

# Make an unordered costmatrix:
costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 2,
  character_type = "unordered"
)

# Convert costmatrix to stategraph:
stategraph <- convert_costmatrix_to_stategraph(costmatrix = costmatrix)

# Check that this is a valid costMatrix object:
is.stateGraph(x = stategraph)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
