% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_unique_trees.r
\name{find_unique_trees}
\alias{find_unique_trees}
\title{Finds only the unique topologies amongst a set}
\usage{
find_unique_trees(trees)
}
\arguments{
\item{trees}{An object of class \code{multiPhylo}.}
}
\value{
An object of class \code{"multiPhylo"}.
}
\description{
Given a set of trees with the same tip labels, returns just the unique topologies present.
}
\details{
Where labelled topologies are generated randomly or modified by (e.g.) removing a tip, it may be useful to isolate just those that are truly unique. The \code{ape} package already has a function for this (\link[ape]{unique.multiPhylo}), but it can be slow when the number of trees is large. This function is thus intended as a faster version.

The function works by breaking down a tree into its' component bipartitions and treating the combination of these as the definition of the tree. It thus escapes problems due to the principle of free rotation. Specifically, these two trees are actually identical:

\preformatted{A  B  C   D  E
 \/    \   \/
  \     \  /
   \     \/
    \    /
     \  /
      \/

B  A  D  E   C
 \/    \/   /
  \     \  /
   \     \/
    \    /
     \  /
      \/}

This becomes clearer if we decompose them into their bipartitions:

AB, DE, CDE, ABCDE

These correspond to the descendants of each internal node (branching point) and the last one is actually ignored (the root node) as it will be present in any tree.
}
\examples{

# Make a set of three identical trees (differing only in "rotation" of nodes):
trees <- ape::read.tree(text = c(
  "((A,B),(C,(D,E)));",
  "((C,(D,E)),(A,B));",
  "((B,A),(C,(E,D)));")
)

# Show that there is only one unique tree:
find_unique_trees(trees = trees)

}
\seealso{
\link[ape]{unique.multiPhylo}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
