% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_nodes.R
\name{date_nodes}
\alias{date_nodes}
\title{Returns node ages for a time-scaled tree}
\usage{
date_nodes(time_tree)
}
\arguments{
\item{time_tree}{A tree (phylo object) with branch lengths representing time and a value for \code{$root.time}.}
}
\description{
Given a tree with branch-lengths scaled to time and a value for \code{$root.time} will return a vector of node ages.
}
\details{
Returns a vector of node ages (terminal and internal) labelled by their node number.
}
\examples{

# Create simple four-taxon tree with edge lengths all
# set to 1 Ma:
time_tree <- ape::read.tree(text = "(A:1,(B:1,(C:1,D:1):1):1);")

# Set root.time as 10 Ma:
time_tree$root.time <- 10

# Get node ages:
date_nodes(time_tree = time_tree)
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
