% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_timeBins.R
\name{check_timeBins}
\alias{check_timeBins}
\title{Check timeBins object for errors}
\usage{
check_timeBins(time_bins)
}
\arguments{
\item{time_bins}{A timeBins object.}
}
\value{
An error message or empty vector if no errors found.
}
\description{
Internal function to check timeBins object for errors.
}
\details{
Internal Claddis function. Nothing to see here. Carry on.
}
\examples{

# Create a time bins object:
time_bins <- matrix(
  data = c(99.6, 93.5, 93.5, 89.3, 89.3, 85.8, 85.8, 83.5, 83.5, 70.6, 70.6, 65.5),
  ncol = 2,
  byrow = TRUE,
  dimnames = list(
    c("Cenomanian", "Turonian", "Coniacian", "Santonian", "Campanian", "Maastrichtian"),
    c("fad", "lad")
  )
)

# Check that this is a valid timeBins object (will return error message as class
# is not set):
check_timeBins(time_bins = time_bins)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
