% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_cladistic_matrix.R
\name{build_cladistic_matrix}
\alias{build_cladistic_matrix}
\title{Creates a morphological data file from a matrix}
\usage{
build_cladistic_matrix(
  character_taxon_matrix,
  header = "",
  character_weights = NULL,
  ordering = NULL,
  symbols = NULL,
  equalise.weights = FALSE,
  ignore_duplicate_taxa = FALSE
)
}
\arguments{
\item{character_taxon_matrix}{A Character-Taxon (columns-rows) matrix, with taxon names as rownames.}

\item{header}{A scalar indicating any header text (defaults to an empty string: "").}

\item{character_weights}{A vector specifying the weights used (if not specified defaults to 1).}

\item{ordering}{A vector indicating whether characters are ordered (\code{"ordered"}) or unordered (\code{"unordered"}) (if no specified defaults to ordered).}

\item{symbols}{The symbols to use if writing to a file (defaults to the numbers 0:9 then the letters A to V).}

\item{equalise.weights}{Optional that overrides the weights specified above make all characters truly equally weighted.}

\item{ignore_duplicate_taxa}{Logical indicating whether or not to ignore (allow; TRUE) duplicate taxa or not (FALSE; default).}
}
\value{
\item{topper}{Contains any header text or costmatrices and pertains to the entire file.}
\item{matrix_N}{One or more matrix blocks (numbered 1 to N) with associated information pertaining only to that matrix block. This includes the block name (if specificed, NA if not), the block datatype (one of "CONTINUOUS", "DNA", "NUCLEOTIDE", "PROTEIN", "RESTRICTION", "RNA", or "STANDARD"), the actual matrix (taxa as rows, names stored as rownames and characters as columns), the ordering type of each character (\code{"ordered"}, \code{"unordered"} etc.), the character weights, the minimum and maximum values (used by Claddis' distance functions), and the original characters (symbols, missing, and gap values) used for writing out the data.}
}
\description{
Creates a morphological data file from a character-taxon matrix.
}
\details{
Claddis generally assumes that matrices will be imported into R from the #NEXUS format, but in some cases (e.g., when using simulated data) it might be desirable to build a matrix within R. This function allows the user to convert such a matrix into the format required by other Claddis functions as long as it only contains a single block.

NB: Currently the function cannot deal directly with costmatrices or continuous characters.
}
\examples{

# Create random 10-by-50 matrix:
character_taxon_matrix <- matrix(sample(c("0", "1", "0&1", NA, ""),
  500,
  replace = TRUE
),
nrow = 10, dimnames =
  list(apply(matrix(sample(LETTERS, 40,
    replace = TRUE
  ), nrow = 10), 1, paste,
  collapse = ""
  ), c())
)

# Reformat for use elsewhere in Claddis:
build_cladistic_matrix(character_taxon_matrix)
}
\seealso{
\link{compactify_cladistic_matrix}, \link{prune_cladistic_matrix}, \link{read_nexus_matrix}, \link{safe_taxonomic_reduction}, \link{write_nexus_matrix}, \link{write_tnt_matrix}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
