% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_edge_lengths.R
\name{bin_edge_lengths}
\alias{bin_edge_lengths}
\title{Edge-lengths present in time-bins}
\usage{
bin_edge_lengths(time_tree, time_bins, pruned_tree = NULL)
}
\arguments{
\item{time_tree}{A time-scaled tree in phylo format with a \code{$root.time} value.}

\item{time_bins}{An object of class \code{timeBins}.}

\item{pruned_tree}{A time-scaled tree in phylo format with a \code{$root.time} value that is a subset of \code{time_tree}.}
}
\value{
\item{binned_edge_lengths}{A vector giving the summed values in millions of years for each time bin. Names indicate the maximum and minimum values for each time bin.}
\item{binned_terminal_edge_lengths}{As above, but counting terminal edges only.}
\item{binned_internal_edge_lengths}{As above, but counting internal edges only.}
}
\description{
Given a time-scaled tree and set of time bin boundaries will sum the edge-lengths present in each bin.
}
\details{
Calculates the total edge duration of a time-scaled tree present in a series of time bins. This is intended as an internal function for rate calculations, but may be of use to someone.

The option of using a \code{pruned_tree} allows the user to correctly classify internal and terminal branches in a subtree of the larger tree. So for example, if taxa A and B are sisters then after pruning B the subtree branch leading to A is composed of an internal and a terminal branch on the complete tree.
}
\examples{

# Create a random 10-taxon tree:
time_tree <- ape::rtree(n = 10)

# Add root age:
time_tree$root.time <- max(diag(ape::vcv(time_tree)))

# Create time bins:
time_bins <- matrix(data = c(seq(from = time_tree$root.time, to = 0,
  length.out = 11)[1:10], seq(from = time_tree$root.time, to = 0,
  length.out = 11)[2:11]), ncol = 2, dimnames = list(LETTERS[1:10],
  c("fad", "lad")))

# Set class:
class(time_bins) <- "timeBins"

# Get edge lengths for each bin:
bin_edge_lengths(time_tree = time_tree, time_bins = time_bins)
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
