# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generate random deviates for the von Mises distribution
#'
#' Generate random deviates for the von Mises distribution.
#'
#' A random variable for circular normal distribution has the form:\cr
#' \deqn{f(theta; mu, kappa) = 1 / (2 * pi * I0(kappa)) * exp(kappa * cos(theta-mu))}
#' theta is withins 0 and 2 * pi.
#'
#' \code{I0(kappa)} in the normalizing constant is the modified Bessel
#' function of the first kind and order zero.
#'
#' @param n number of observations.
#' @param mu mean direction of the distribution.
#' @param k non-negative numeric value for the concentration parameter of the
#' distribution
#'
#' @return a vector
#' @examples
#' n  <- 100
#' mu <- 0
#' k  <- 10
#' vm3_de <- rvm(n, mu, k)       ## in degree unit
#' vm3_pi <- vm3_de %% (2 * pi)  ## in radian unit
#' @export
rvm <- function(n, mu, k) {
    .Call('_CircularDDM_rvm', PACKAGE = 'CircularDDM', n, mu, k)
}

#' Find First k Positive Zeros for the Bessel Functions
#'
#' Find first k positive zeros of the Bessel function J(n,x) or Y(n,x)
#' using Halley's method.
#'
#' @param nu The order of the corresponding Bessel function.
#' @param k an integer for first k positive zeros.
#' @param kind 0, 1, or 2. A switch selects \link{besselI}, \link{besselJ} or
#' \link{besselY}
#'
#' @return a vector
#' @references
#' \href{http://au.mathworks.com/matlabcentral/fileexchange/6794-bessel-function-zeros/content/besselzero.m}{besselzero.m}
#' @examples
#' nu <- seq(0, 5, length.out=10)
#' output <- matrix(numeric(5*length(nu)), nrow=5)
#'   for(i in 1:length(nu)) {
#'     output[,i] <- besselzero(nu[i], 5, 1)
#'   }
#' output
#'
#' output <- matrix(numeric(5*length(nu)), nrow=5)
#' for(i in 1:length(nu)) {
#'     output[,i] <- besselzero(nu[i], 5, 2)
#' }
#' output
#' @export
besselzero <- function(nu, k, kind) {
    .Call('_CircularDDM_besselzero', PACKAGE = 'CircularDDM', nu, k, kind)
}

#' Log-Likelihood for Continuous Reports
#'
#' Calculate log-likelihood of the continuous reports, using
#' part part in equation (23) on p 433.
#'
#' @param x a matrix storing a first column as RT and a second column of
#' continuous responses/reports/outcomes. Each row is a trial.
#' @param pVec a parameter vector with the order [a, vx, vy, t0, s],
#' or [thresh, mu1, mu2, ndt, sigmasq], using alternative names.
#'
#' @return a vector
#' @references Smith, P. L. (2016). Diffusion Theory of Decision Making in
#' Continuous Report, Psychological Review, 123 (4), 425--451.
#' @examples
#' x <- cbind(
#' RT=c(1.2595272, 0.8693937, 0.8009044, 1.0018933, 2.3640007, 1.0521304),
#' R =c(1.9217430, 1.7844653, 0.2662521, 2.1569724, 1.7277440, 0.8607271)
#' )
#' pVec <- c(a=2.45, vx=1.5, vy=1.25, t0=.1, s=1)
#' den  <- logLik_resp(x, pVec=pVec); den
#' @export
logLik_resp <- function(x, pVec) {
    .Call('_CircularDDM_logLik_resp', PACKAGE = 'CircularDDM', x, pVec)
}

#' Log-Likelihood for Circular First Passage Time
#'
#' Calculate circular log-likelihood of the first passage time, using
#' equation (22) on p 432.
#'
#' @param x a matrix storing a first column as RT and a second column of
#' continuous responses/reports/outcomes. Each row is a trial.
#' @param pVec a parameter vector with the order [a, vx, vy, t0, s],
#' a stands for response threshold, vx is the drift rate along x axis,
#' vy is the drift rate along y axis, t0 is the non-decision time, and s
#' is the within-trial standard deviation.
#' @param k a precision for bessel function. The larger the k is, the larger
#' the memory space is required. Default is 141.
#'
#' @return a vector
#' @references Smith, P. L. (2016). Diffusion Theory of Decision Making in
#' Continuous Report, Psychological Review, 123 (4), 425--451.
#' @examples
#' x <- cbind(
#' RT=c(1.2595272, 0.8693937, 0.8009044, 1.0018933, 2.3640007, 1.0521304),
#' R =c(1.9217430, 1.7844653, 0.2662521, 2.1569724, 1.7277440, 0.8607271)
#' )
#' pVec <- c(a=2.45, vx=1.5, vy=1.25, t0=.1, s=1)
#' den  <- logLik_dt(x, pVec=pVec);
#' den
#' @export
logLik_dt <- function(x, pVec, k = 141L) {
    .Call('_CircularDDM_logLik_dt', PACKAGE = 'CircularDDM', x, pVec, k)
}

#' The Circular Drift-diffusion Distribution
#'
#' Density function and random generation for the circular drift-diffusion
#' model with theta vector equal to \code{pVec}.  \code{dcddm} is the
#' equation (23) on page 433 in Smith (2016).
#'
#' @param x a matrix storing a first column as RT and a second column of
#' continuous responses/reports/outcomes. Each row is a trial.
#' @param n number of observations.
#' @param pVec a parameter vector with the order [a, vx, vy, t0, s],
#' or [thresh, mu1, mu2, ndt, sigmasq]. The order matters.
#' @param k a precision for calculating the infinite series in \code{dcddm}. The
#' larger the k is, the larger the memory space is required. Default is 141.
#' @param p a precision for random walk step in \code{rcddm}. Default is 0.15
#' second
#' @return \code{dcddm} gives a log-likelihood vector. \code{rddm} generates
#' random deviates, returning a n x 3 matrix with the columns: RTs, choices
#' and then angles.
#' @references Smith, P. L. (2016). Diffusion Theory of Decision Making in
#' Continuous Report, Psychological Review, 123 (4), 425--451.
#' @examples
#' ## dcddm example
#' x <- cbind(
#' RT= c(1.2595272, 0.8693937, 0.8009044, 1.0018933, 2.3640007, 1.0521304),
#' R = c(1.9217430, 1.7844653, 0.2662521, 2.1569724, 1.7277440, 0.8607271)
#' )
#' pVec <- c(a=2.45, vx=1.5, vy=1.25, t0=.1, s=1)
#' dcddm(x, pVec)
#'
#' ## rcddm example
#' pVec <- c(a=2, vx=1.5, vy=1.25, t0=.25, s=1)
#' den  <- rcddm(1e3, pVec);
#' hist(den[,1], breaks = "fd", xlab="Response Time",  main="Density")
#' hist(den[,3], breaks = "fd", xlab="Response Angle", main="Density")
#' @export
dcddm <- function(x, pVec, k = 141L) {
    .Call('_CircularDDM_dcddm', PACKAGE = 'CircularDDM', x, pVec, k)
}

#' @rdname dcddm
#' @export
rcddm <- function(n, pVec, p = 0.15) {
    .Call('_CircularDDM_rcddm', PACKAGE = 'CircularDDM', n, pVec, p)
}

