% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rose_diag.R
\name{rose_diag}
\alias{rose_diag}
\title{Rose diagram in ggplot2 inspired from rose.diag in package circular.}
\usage{
rose_diag(x, bins = 15, color = "red", alpha = 1, start = 0,
  add = FALSE, template = "rad", direction = NULL)
}
\arguments{
\item{x}{a vector of circular coordinates in radiants \eqn{[0,2 \pi)}.}

\item{bins}{number of bins}

\item{color}{color of the line and of the fill}

\item{alpha}{transparency}

\item{start}{the starting angle of the 0 (the North)}

\item{add}{add the rose_diag to an existing ggplot2 plot}

\item{template}{radiants or wind rose. the values are \code{c("rad","wind_rose")}..
default is \code{"rad"}}

\item{direction}{1, clockwise; -1, anticlockwise. For template = "rad" direction is -1 while
for template = "wind_rose" direction is 1.}
}
\value{
The plot in ggplot2 format.
}
\description{
Rose diagram in ggplot2 inspired from rose.diag in package circular.
}
\examples{


library(CircSpaceTime)
x <- circular::rwrappedstable(200, index = 1.5, skewness = .5)
x1 <- circular::rwrappedstable(200, index = 2, skewness = .5)
x2 <- circular::rwrappedstable(200, index = 0.5, skewness = 1)
rose_diag(x, bins = 15, color = "green")
rose_diag(x1, bins = 15, color = "blue", alpha = .5, add = TRUE)
rose_diag(x2, bins = 15, color = "red", alpha = .5, add = TRUE)

}
