axialnntsplot<-function (cpars = 1/sqrt(pi), M = 0, ...)
{
  if (M == 0) {
    x <- rep(1/(pi), 2)
    return(plot(c(0, pi), x, type = "l", ...))
  }
  size <- length(cpars)
  if (size != M + 1)
    return("Length of cpars must be equal to M+1")
  if (abs(sum(Mod(cpars)^2) - 1/(pi)) > 1e-10)
    return("sum of the squared norms of componentes greater than condition")
  nntsplotintaxial <- function(theta) {
    res <- axialnntsdensity(theta, cpars, M)
    return(res)
  }
  return(curve(nntsplotintaxial, 0, pi, ...))
}

