% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{gen.logistic}
\alias{gen.logistic}
\title{Logistic map}
\usage{
gen.logistic(mu, iter = 5000, x0 = 1e-04)
}
\arguments{
\item{mu}{parameter of the logistic function. mu should be from the interval (0,4).}

\item{iter}{number of iterations of the logistic function. Default is 5000.}

\item{x0}{the initial value of the series. Should be from the interval (0,1). Default is 0.0001.}
}
\value{
numeric vector with the iterations of the logistic map.
}
\description{
Generate iterations of the logistic map defined as x[t+1] = mu * x[t] * (1 - x[t]).
}
\examples{
vec.x <- gen.logistic(mu = 3.55, iter = 200)
plot(vec.x, type = "l")
}
\keyword{logistic}
\keyword{map}
