% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_metamodelTextual.R
\name{create_metamodelTextual}
\alias{create_metamodelTextual}
\title{Send metamodel to \code{modelTextualUI()} and run shiny application}
\usage{
create_metamodelTextual(metamodelFile)
}
\arguments{
\item{metamodelFile}{Path to existing metmodel file.}
}
\value{
Updated metamodel text.
}
\description{
Used by Pirana to send existing metamodel to \code{modelTextualUI()} for
editing, and after returning, saves it as a metamodel file e.g, .mmdl.
}
\details{
If \code{DOSING CYCLE} block is presented in the metamodel, it will be
transferred to \code{COLDEF} block with a warning.
}
\examples{
if (interactive()) {
mmdl_file <- system.file("vignettesdata/OneCpt_IVInfusion.mmdl",
  package = "Certara.RsNLME")

create_metamodelTextual(
  mmdl_file
  )
}
}
