% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_ModelTemplateTokens.R
\name{write_ModelTemplateTokens}
\alias{write_ModelTemplateTokens}
\title{Prints NLME metamodel template file and token json file using given options,
filepaths and data}
\usage{
write_ModelTemplateTokens(
  TemplateFilePath = "template.txt",
  TokensFilePath = "tokens.json",
  Description = "",
  Author = "",
  DataFilePath,
  DataMapping = NULL,
  ColDef = "",
  PMLParametersSets,
  EstArgs = specify_EngineParams(),
  SimArgs = "",
  Tables = list(),
  AppendixRows = "",
  OmegaSearchBlocks = list()
)
}
\arguments{
\item{TemplateFilePath}{TemplateFilePath NLME template file path to be
written (usually txt).}

\item{TokensFilePath}{json file path to be written (usually json).}

\item{Description}{A problem name to be outputted in Description section.}

\item{Author}{The author information for the model to be outputted in Author
section.}

\item{DataFilePath}{A data file path used by NLME.}

\item{DataMapping}{A named vector ModelTerm = DataTerm for the used data
file.}

\item{ColDef}{A character string specifying additional column definitions in
NLME column definition format. See
\url{https://onlinehelp.certara.com/phoenix/8.4/index.html#t=Phoenix_UserDocs\%2FPML\%2FColumn_mappings.htm}}

\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{EstArgs}{Estimation arguments for the model template. Please use
\code{\link{specify_EngineParams}} to specify the arguments passed to NLME.}

\item{SimArgs}{Simulation arguments for the model template. Please use
\code{\link{specify_SimParams}} to specify the arguments passed to NLME.}

\item{Tables}{A list of \code{Table} class instances specifying properties of the
tables to be generated after fitting or during simulation.}

\item{AppendixRows}{Additional rows to include in the model template appendix
in NLME column definition format. See
\url{https://onlinehelp.certara.com/phoenix/8.4/index.html#t=Phoenix_UserDocs\%2FPML\%2FColumn_mappings.htm}}

\item{OmegaSearchBlocks}{A list of character vectors representing omega names
to try to build block omegas.}
}
\value{
A list containing statements written to template and tokens files.
}
\description{
This function generates and writes the model template and tokens files based
on the provided inputs.
}
\details{
Terms \verb{<DosepointName>_Duration} or \verb{<DosepointName>_Rate} could be
used to map rate/duration columns for the current dosepoints. Term
\verb{<ObservationName>BQL} could be used to map BQL flag for the current
observation. \code{AMT} term could be used to map different main dosepoints (i.e.
A1 will be mapped for \code{Gamma}, Aa for \code{First-Order} absorption etc.) If \code{AMT}
term is used, additional terms \code{Duration} or \code{Rate} could be used; current
function will map it to the main dosepoint of each Parameter set. But it is
possible to map duration/rate for some dosepoint directly using terms
\verb{<DosepointName>_Duration} or \verb{<DosepointName>_Rate}, it will override
\code{Duration} or \code{Rate} terms mapping for current dosepoint.
}
\examples{
# Write model template and tokens files
PMLParametersSets <- create_ModelPK(CompartmentsNumber = c(1,2))
# write test data frame
TempFolder <- tempdir()
TemplateFilePath <- file.path(TempFolder, "template.txt")
TokensFilePath <- file.path(TempFolder, "tokens.json")
DataFilePath <- file.path(TempFolder, "Data.csv")
write.csv(data.frame(id = 'id',
                     time = 'time',
                     AMT = 'AMT',
                     Conc = 'Conc',
                     age = 'age',
                     Weight = 'Weight',
                     CObsBQL = 'CObsBQL'),
                     DataFilePath)
write_ModelTemplateTokens(TemplateFilePath = TemplateFilePath,
                          TokensFilePath = TokensFilePath,
                          Description = "1-2Cpts try",
                          Author = "Certara",
                          DataFilePath = DataFilePath,
                          DataMapping = c(ID = "id",
                                          time = "time",
                                          CObs = "Conc",
                                          AMT = "AMT",
                                          "age"),
                          ColDef = "",
                          PMLParametersSets = PMLParametersSets,
                          EstArgs = specify_EngineParams(method = "QRPEM"),
                          SimArgs = specify_SimParams(numReplicates = 1000L),
                          Tables = list(Table(Name = "simtable1.csv",
                                              KeepSource = TRUE,
                                              VariablesList = "C",
                                              ForSimulation = TRUE)),
                          OmegaSearchBlocks = list(c("nCl", "nV"), c("nCl2", "nV2")))

}
\seealso{
\code{\link[=specify_EngineParams]{specify_EngineParams()}}, \code{\link[=specify_SimParams]{specify_SimParams()}}, \code{\link[=Table]{Table()}}
}
