% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Covariate.R
\name{list_Covariates}
\alias{list_Covariates}
\title{List Covariates in the currrent PML set}
\usage{
list_Covariates(PMLParametersSets, IncludeAll = FALSE, IncludeCustom = TRUE)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{IncludeAll}{Logical. Should the names of covariates with \code{None} state
or covariates inside structural parameters with \code{None} state be included or
not.}

\item{IncludeCustom}{Logical. Should the names of \code{covariate}, \code{fcovariate}
and \code{interpolate} statements (from the PML code of custom spaces) be
included or not. Default is \code{TRUE}.}
}
\value{
A character vector containing the names of covariates.
}
\description{
This function lists the names of covariates in a given set of
PMLParametersSets.
}
\examples{
PMLParametersSets <- get_PMLParametersSets()
PMLParametersSets <- add_Covariate(PMLParametersSets,
                                   Name  = "WT")
list_Covariates(PMLParametersSets)

}
\seealso{
\code{\link[=add_Covariate]{add_Covariate()}} \code{\link[=remove_Covariate]{remove_Covariate()}} \code{\link[=Covariate]{Covariate()}}
}
