% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampling_FWHM.R
\name{resampling_FWHM}
\alias{resampling_FWHM}
\title{Full Width Half Maximum Resampling}
\usage{
resampling_FWHM(spectra, wavelengths, new_wavelengths, FWHM, threads = 1L)
}
\arguments{
\item{spectra}{A \code{data.table}, \code{data.frame}, or \code{matrix} where
columns represent bands and rows samples (i.e., pixels).}

\item{wavelengths}{A \code{numeric} vector describing the current positioning
of the spectral bands within \code{spectra}.}

\item{new_wavelengths}{A \code{numeric} vector describing positioning of the
new spectral bands to resample.}

\item{FWHM}{A \code{numeric} vector describing the Full Width Half Maximums of
the new spectral bands. The length of this vector should be equal than the length
of \code{new_wavelengths}.}

\item{threads}{An \code{integer} specifying the number of threads to use.
Experiment to see what works best for your data on your hardware.}
}
\value{
It returns a \code{data.table} with the resampled spectra, where columns
are the new bands and rows are samples.
}
\description{
It resample spectra data using Full Width Half Maximum (FWHM).
}
\examples{

mean <- 50
sd1 <- 5
sd2 <- 10
n <- 100

test <- matrix(c(dnorm(1:n, mean = mean, sd = sd1),
               dnorm(1:n, mean = mean, sd = sd2)),
               nrow = 2,
               byrow = TRUE)

current_bands <- 1:n
new_bands <- seq(10, 90, by = 5)
FHWM <- rep(5, length(new_bands))

resampling_FWHM(spectra = test,
                wavelengths = current_bands,
                new_wavelengths = new_bands,
                FWHM = FHWM)

}
\author{
J. Antonio Guzmán Q.
}
