% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expcube.R
\name{expcube}
\alias{expcube}
\title{Expectation of CUBE models}
\usage{
expcube(m,pai,csi,phi)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{pai}{Uncertainty parameter}

\item{csi}{Feeling parameter}

\item{phi}{Overdispersion parameter}
}
\description{
Compute the expectation of a CUBE model without covariates.
}
\examples{
m<-10
pai<-0.1
csi<-0.7
phi<-0.2
meancube<-expcube(m,pai,csi,phi)
}
\references{
Iannario M. (2014). Modelling Uncertainty and Overdispersion in Ordinal Data,
\emph{Communications in Statistics - Theory and Methods}, \bold{43}, 771--786 \cr
Iannario, M. (2015). Detecting latent components in ordinal data with overdispersion by means
of a mixture distribution, \emph{Quality & Quantity}, \bold{49}, 977--987
}
\seealso{
\code{\link{varcube}}, \code{\link{varcub00}}, \code{\link{expcub00}}
}
\keyword{distribution}
