% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficient_alpha_plot.R
\name{coefficient_alpha_plot}
\alias{coefficient_alpha_plot}
\title{coefficient_alpha_visualization}
\usage{
coefficient_alpha_plot(responses, title = "Coefficient Alpha", alpha_round = 3)
}
\arguments{
\item{responses}{A dichotompus item response object (a dataframe or a matrix)}

\item{title}{Title of the plot}

\item{alpha_round}{Rounding option for coefficient alpha. default to 4 decimal points.}
}
\value{
A data frame sorted by coefficient alpha if dropped in ascending order. A plot of coefficient alpha of each item in relation to the overall coefficient alpha.
}
\description{
plotting results of coefficient alpha analysis from the Classical test theory framework.
Items that increase the overall coefficient alpha when dropped will be shown above the overall alpha line.
This helps identifying items that could be revised or removed based on its influence to unidimensional coefficient alpha reliability of the test.

This function can also be used with polytomous item responses.
However, it is recommended for users to perform reverse coding as necessary before implementing this function.
}
\examples{

data(reliability_df)

# To plot coefficient alpha with the overall alpha rounding of 3 decimal places

coefficient_alpha_plot(responses = reliability_df,
      title = "Coefficient Alpha Plot", alpha_round = 3)

}
