% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cste_surv.R
\name{cste_surv}
\alias{cste_surv}
\title{Estimate the CSTE curve for time to event outcome with right censoring.}
\usage{
cste_surv(x, y, z, s, h)
}
\arguments{
\item{x}{samples of biomarker (or covariate) which is a \eqn{n*1} vector 
and should be scaled between 0 and 1.}

\item{y}{samples of time to event which is a \eqn{n*1} vector.}

\item{z}{samples of treatment indicator which is a \eqn{n*K} matrix.}

\item{s}{samples of censoring indicator which is a \eqn{n*1} vector.}

\item{h}{kernel bandwidth.}
}
\value{
A \eqn{n*K} matrix, estimation of \eqn{\beta(x)}.
}
\description{
Estimate the CSTE curve for time to event outcome with right censoring. 
The working model 
is \deqn{\lambda(t| X, Z) = \lambda_0(t) \exp(\beta^T(X)Z + g(X)),}
which implies that \eqn{CSTE(x) = \beta(x)}.
}
\references{
Ma Y. and Zhou X. (2017). 
Treatment selection in a randomized clinical trial via covariate-specific 
treatment effect curves, \emph{Statistical Methods in Medical Research}, 26(1), 124-141.
}
\seealso{
\code{\link{cste_surv_SCB}}
}
