% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{specify_clusters}
\alias{specify_clusters}
\title{Assign locations to clusters in a CRT}
\usage{
specify_clusters(
  trial = trial,
  c = NULL,
  h = NULL,
  algorithm = "NN",
  reuseTSP = FALSE,
  auxiliary = NULL
)
}
\arguments{
\item{trial}{A CRT object or data frame containing (x,y) coordinates of
households}

\item{c}{integer: number of clusters in each arm}

\item{h}{integer: number of locations per cluster}

\item{algorithm}{algorithm for cluster boundaries, with options:
\tabular{ll}{
\code{NN}\tab Nearest neighbour: assigns equal numbers of locations to each cluster \cr
\code{kmeans}\tab kmeans clustering: aims to partition locations so that each
belongs to the cluster with the nearest centroid.\cr
\code{TSP}\tab travelling salesman problem heuristic: Assigns locations sequentially
along a travelling salesman path.\cr
}}

\item{reuseTSP}{logical: indicator of whether a pre-existing path should be used by
the TSP algorithm}

\item{auxiliary}{\code{"CRTsp"} object containing external cluster and or arm assignments.}
}
\value{
A list of class \code{"CRTsp"} containing the following components:
\tabular{lll}{
\code{geom_full}   \tab list: \tab summary statistics describing the site,
and cluster assignments.\cr
\code{trial} \tab data frame: \tab rows correspond to geolocated points, as follows:\cr
\tab \code{x} \tab numeric vector: x-coordinates of locations \cr
\tab \code{y} \tab numeric vector: y-coordinates of locations \cr
\tab \code{cluster} \tab factor: assignments to cluster of each location  \cr
\tab \code{...} \tab other objects included in the input \code{"CRTsp"} object or data frame \cr
}
}
\description{
\code{specify_clusters} algorithmically assigns locations to clusters by grouping them geographically
}
\details{
Either \code{c} or \code{h} must be specified. If both are specified
the input value of \code{c} is ignored.\cr\cr
The \code{reuseTSP} parameter is used to allow the path to be reused
for creating alternative allocations with different cluster sizes.\cr\cr
If an auxiliary \code{auxiliary} \code{"CRTsp"} object is specified then the other options are ignored
and the cluster assignments (and arm assignments if available) are taken from the auxiliary object.
The trial data frame is augmented with a column \code{"nearestPixel"} containing the distance to boundary of the nearest
grid pixel in the auxiliary. If the auxiliary is a grid with \code{design$geometry} set to \code{'triangle'},
\code{'square'} or \code{'hexagon'} then the distance is computed to the edge of the nearest grid pixel in the discordant arm
(using a circular approximation for the perimeter) rather than to the point location itself. If the point is within
the pixel then the distance is given a negative sign.\cr
}
\examples{
#Assign clusters of average size h = 40 to a test set of co-ordinates, using the kmeans algorithm
exampletrial <- specify_clusters(trial = readdata('exampleCRT.txt'),
                            h = 40, algorithm = 'kmeans', reuseTSP = FALSE)
}
