% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_mb.R
\name{CPP.mb}
\alias{CPP.mb}
\title{CPP with multiple perspectives for decision-making, based on the 'Moneyball' principle.}
\usage{
CPP.mb(t1, t2, m, q, s)
}
\arguments{
\item{t1}{Decision matrix of Alternatives (rows) and Criteria (columns) in the moment '1'. Benefit criteria must be positive and cost criteria negative.}

\item{t2}{Decision matrix of Alternatives (rows) and Criteria (columns) in the following moment '2'. Benefit criteria must be positive and cost criteria negative.}

\item{m}{Vector of alternatives' market values.}

\item{q}{Vector of quantiles, indicating the classes' profiles.}

\item{s}{Shape of a Beta PERT distribution, as described in the package 'mc2d'. There is no default value, however the higher the shape the higher the kurtosis, which emulates the precision of data.}
}
\value{
Class assigns the alternatives to classes, defined by the indicated profiles. The list of classes also shows the decision matrices to be modeled by CPP-PP. CPP-mb indicates the final scores per class.
}
\description{
The algorithm evaluates alternatives by integrating the CPP-Tri, the CPP-Malmquist, the CPP-Gini, the alternatives' market values and the CPP by axes. The CPP-mb was originally applied in sports science to evaluate players' performance.
}
\examples{
## Decision matrix of the previous moment '1'.
Alt.1 = c(2,30,86,-5)
Alt.2 = c(4,26,77,-12)
Alt.3 = c(3,22,93,-4)
Alt.4 = c(6,34,65,-10)
Alt.5 = c(5,31,80,-8)
Alt.6 = c(6,29,79,-9)
Alt.7 = c(8,37,55,-15)
Alt.8 = c(10,21,69,-11)
t1 = rbind(Alt.1,Alt.2,Alt.3,Alt.4,Alt.5,Alt.6,Alt.7,Alt.8)
## Decision matrix of the following moment '2'.
Alt.1 = c(3,29,82,-3)
Alt.2 = c(6,28,70,-8)
Alt.3 = c(2,20,99,-8)
Alt.4 = c(5,31,62,-14)
Alt.5 = c(9,27,73,-5)
Alt.6 = c(4,33,85,-13)
Alt.7 = c(9,39,59,-10)
Alt.8 = c(8,19,77,-9)
t2 = rbind(Alt.1,Alt.2,Alt.3,Alt.4,Alt.5,Alt.6,Alt.7,Alt.8)
m = c(100,120,150,140,90,70,110,130) # Market values
q = c(0.65,0.35) # quantiles of class profiles
s = 4 # Shape
CPP.mb(t1,t2,m,q,s)
}
\references{
Sant'Anna, Annibal P. (2015). Probabilistic Composition of Preferences: Theory and Applications, Springer.

Lewis, Michael. (2004) Moneyball: The art of winning an unfair game. WW Norton & Company.

Gaviao, Luiz O. & Lima, Gilson B.A. (2017) Support decision to player selection: an application of the CPP in soccer, Novas Edições Acadêmicas [in Portuguese].
}
