% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{Normalise.data.frame}
\alias{Normalise.data.frame}
\title{Normalise a data frame}
\usage{
\method{Normalise}{data.frame}(x, global_specs = NULL, indiv_specs = NULL, directions = NULL, ...)
}
\arguments{
\item{x}{A data frame}

\item{global_specs}{Specifications to apply to all columns, apart from those specified by \code{indiv_specs}. See details.}

\item{indiv_specs}{Specifications applied to specific columns, overriding those specified in \code{global_specs}. See details.}

\item{directions}{An optional data frame containing the following columns:
\itemize{
\item \code{iCode} The indicator code, corresponding to the column names of the data frame
\item \code{Direction} numeric vector with entries either \code{-1} or \code{1}
If \code{directions} is not specified, the directions will all be assigned as \code{1}. Non-numeric columns do not need
to have directions assigned.
}}

\item{...}{arguments passed to or from other methods.}
}
\value{
A normalised data frame
}
\description{
Normalises a data frame using specifications specified in \code{global_specs}. Columns can also optionally be
normalised with individual specifications using the \code{indiv_specs} argument. If variables should have their
directions reversed, this can be specified using the \code{directions} argument. Non-numeric columns are ignored
automatically by this function. By default, this function normalises each indicator using the "min-max" method, scaling indicators to lie between
0 and 100. This calls the \code{\link[=n_minmax]{n_minmax()}} function. COINr has a number of built-in normalisation functions of the form \verb{n_*()}. See \href{https://bluefoxr.github.io/COINr/articles/normalise.html#built-in-normalisation-functions}{online documentation}
for details.
}
\details{
\subsection{Global specification}{

The \code{global_specs} argument is a list which specifies the normalisation function and any function parameters
that should be used to normalise the columns of \code{x}. Unless \code{indiv_specs} is specified, this will be applied
to all numeric columns of \code{x}. The list should have two entries:
\itemize{
\item \code{.$f_n}: the name of the function to use to normalise each column
\item \code{.$f_n_para}: any further parameters to pass to \code{f_n}, apart from the numeric vector (each column of \code{x})
}

In this list, \code{f_n} should be a character string which is the name of a normalisation
function. For example, \code{f_n = "n_minmax"} calls the \code{\link[=n_minmax]{n_minmax()}} function. \code{f_n_para} is a list of any
further arguments to \code{f_n}. This means that any function can be passed to \code{\link[=Normalise]{Normalise()}}, as long as its
first argument is \code{x}, a numeric vector, and it returns a numeric vector of the same length. See \code{\link[=n_minmax]{n_minmax()}}
for an example.

\code{f_n_para} is \emph{required} to be a named list. So e.g. if we define a function \code{f1(x, arg1, arg2)} then we should
specify \code{f_n = "f1"}, and \code{f_n_para = list(arg1 = val1, arg2 = val2)}, where \code{val1} and \code{val2} are the
values assigned to the arguments \code{arg1} and \code{arg2} respectively.

The default list for \code{global_specs} is: \code{list(f_n = "n_minmax", f_n_para = list(l_u = c(0,100)))}.

Note, all COINr normalisation functions (passed to \code{f_n}) are of the form \verb{n_*()}. Type \code{n_} in the R Studio console and press the Tab key to see a list.
}

\subsection{Individual column specification}{

Optionally, columns of \code{x} can be normalised with different normalisation functions and parameters using the
\code{indiv_specs} argument. This must be specified as a named list e.g. \code{list(i1 = specs1, i2 = specs2)} where
\code{i1} and \code{i2} are column names of \code{x} to apply individual normalisation to, and \code{specs1} and \code{specs2} are
respectively lists of the same format as \code{global_specs} (see above). In other words, \code{indiv_specs} is a big
list wrapping together \code{global_specs}-style lists. Any numeric columns of \code{x} not named in \code{indiv_specs} (
i.e. those not in \code{names(indiv_specs)}) are normalised using the specifications from \code{global_specs}. So
\code{indiv_specs} lists the exceptions to \code{global_specs}.

See also \code{vignette("normalise")} for more details.
}
}
\examples{
iris_norm <- Normalise(iris)
head(iris_norm)

}
