% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_poles.R
\name{environmental_cof_poles}
\alias{environmental_cof_poles}
\title{Environmental cost of Failure for Poles}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
environmental_cof_poles(pole_asset_category)
}
\arguments{
\item{pole_asset_category}{String The type of pole asset category
Options: \code{pole_asset_category = c("LV Poles", "6.6/11kV Poles",
"20kV Poles", "33kV Pole", "66kV Pole")}.}
}
\value{
Numeric. Financial consequences of failure for Poles
}
\description{
This function calculates environmental consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Environmental consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
environmental_cof_poles(pole_asset_category = "33kV Pole")
}
