% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORci.R
\name{ORci}
\alias{ORci}
\title{Calculate odds ratios and their confidence intervals
from \code{glm} object}
\usage{
ORci(x, conf.level = 0.95)
}
\arguments{
\item{x}{\code{glm} object (logistic regression only!).}

\item{conf.level}{the confidence interval. Default is 0.95.}
}
\value{
an object \code{ORci} and \code{matirix} classes with four columns.
  \describe{
   \item{OR}{odds ratio}
   \item{lwr}{lower conficence intarval}
   \item{upr}{upper conficence intarval}
   \item{p.value}{P value by logistic regression}
  }
}
\description{
Calculate odds ratios and their confidence intervals
from \code{glm} object
}
\examples{
require(graphics)
require(MASS)
data(birthwt)
x <- glm(low ~  age + lwt + smoke + ptl + ht + ui, data = birthwt,
         family = binomial)
OR1 <- ORci(x)
CIplot(OR1, las = 1)
}
