% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGLMsimu.functions.R
\name{simu.inter.dat.interboth}
\alias{simu.inter.dat.interboth}
\title{Simulated Data with DGLM model}
\usage{
simu.inter.dat.interboth(
  n.rep = 3,
  n.level.env = 2,
  n.obs.per.rep = 150,
  n.loci = 8,
  which.mean.loci = c(3:4),
  hypo.mean.para = c(1, 4),
  incept.mean = 36,
  which.var.loci = c(4:5),
  hypo.var.para = c(2, 5),
  incept.var = -2,
  which.env.inter.mean = 2,
  which.loci.inter.mean = 7,
  hypo.inter.para.mean = 2.5,
  which.env.inter.var = 2,
  which.loci.inter.var = 8,
  hypo.inter.para.var = 3.8,
  simu.prob.var = rep(0.5, n.loci),
  rc.val = 40,
  ran.seed = NULL
)
}
\arguments{
\item{n.rep}{The number of repetitions of each environment level. Defaults to 3.}

\item{n.level.env}{The number of environment variable levels. Defaults to 2.}

\item{n.obs.per.rep}{A parameter to accommodate repetitions in the data set. Defaults to 150.}

\item{n.loci}{The number of gene loci in data set. Defaults to 8.}

\item{which.mean.loci}{A vector that specifies which gene loci are significant in the mean model. Defaults to the vector c(3:4).}

\item{hypo.mean.para}{A vector that contains the slopes of the gene locations (from which.mean.loci) in the mean model. Defaults to the vector c(1,4).}

\item{incept.mean}{The intercept for the mean model portion of the DGLM. Defaults to 36.}

\item{which.var.loci}{A vector that specifies which gene loci are significant in the variance model. Defaults to c(4:5).}

\item{hypo.var.para}{A vector that contains the slopes of the gene locations (from which.var.loci) in the variance model. Defaults to c(2,5).}

\item{incept.var}{The intercept for the variance model portion of the DGLM. Defaults to -2.}

\item{which.env.inter.mean}{Specifies which level of environment significantly interacts in the mean model. This is one of the parameters that supports model-building with interaction terms. Defaults to 2.}

\item{which.loci.inter.mean}{Specifies which gene location interacts with the environment level in the mean model. This is one of the parameters that supports model-building with interaction terms. Defaults to 7.}

\item{hypo.inter.para.mean}{The interaction effect between the specified environment level and the specified gene location in the mean model. This is another parameter that supports model-building with interaction terms. Defaults to 2.5.}

\item{which.env.inter.var}{Specifies which level of environment significantly interacts in the variance model. This is another parameter that supports model-building with interaction terms. Defaults to 2.}

\item{which.loci.inter.var}{Specifies which gene location interacts with the environment level in the variance model. This is another parameter that supports model-building with interaction terms. Defaults to 8.}

\item{hypo.inter.para.var}{Interaction effect between the specified environment level and the specified gene location in the variance model. Defaults to 3.8.}

\item{simu.prob.var}{The probability of each lcoi to be zero or one. Different loci may have different probability and can be adjusted as needed. Defaults to rep(0.5,n.loci).}

\item{rc.val}{A parameter used to control right-censored data. It sets an upper limit such that if an observation is above a certain range, that observation cannot be included in the data set. Default value is 40.}

\item{ran.seed}{The random seed to be used. Defaults to NULL.}
}
\value{
The function returns a data frame containing the data built from the simulation. It provides data for stress values, an environment variable with two levels (0 and 1), and levels for each simulated gene variable.
}
\description{
This function implements a simulation based on randomly-generated data following a known structure to create a double generalized linear model (DGLM). In particular, it supports the use of interaction terms in the DGLM.
}
\examples{
test.data <- simu.inter.dat.interboth(n.rep = 3, n.obs.per.rep = 15, ran.seed = 1)
}
