% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{wiener_index_centrality}
\alias{wiener_index_centrality}
\title{Wiener Index Centrality}
\usage{
wiener_index_centrality(
  x,
  vids = V(x),
  mode = c("all", "out", "in"),
  weights = NULL
)
}
\arguments{
\item{x}{An igraph or a network object.}

\item{vids}{Nodes to be considered in the calculation.}

\item{mode}{A character value indicating whether the shortest paths "in" or "out" of the nodes in directed graphs should be considered. For undirected graphs, "all" is used.}

\item{weights}{Numeric vector indicating weights of the edges.}
}
\value{
A numeric vector including the centrality values for each node.
The centrality values represent the Wiener Index Centrality measure for each node in the network.
}
\description{
This function computes the Wiener Index Centrality for nodes in a network. The Wiener index is a measure of centrality that computes the sum of all shortest paths between a node and all other related nodes in the graph. In essence, it is similar to closeness centrality, but without taking the reciprocal, resulting in a measure with the opposite meaning.
}
\examples{

data(zachary)

wiener_index_centrality(zachary)

}
\references{
Scardoni, G. and Carlo Laudanna, C.B.M.C. (2011). Network centralities for Cytoscape. University of Verona.
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
