% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_estimate_tmle_ate.R
\name{ce_estimate_tmle_ate}
\alias{ce_estimate_tmle_ate}
\title{Causal inference with multiple treatments using TMLE for ATE effects}
\usage{
ce_estimate_tmle_ate(y, w, x, sl_library, ...)
}
\arguments{
\item{y}{A numeric vector (0, 1) representing a binary outcome.}

\item{w}{A numeric vector representing the treatment groups.}

\item{x}{A dataframe, including all the covariates but not treatments.}

\item{sl_library}{A character vector of prediction algorithms.
A list of functions included in the SuperLearner package
can be found with \code{\link[SuperLearner:listWrappers]{listWrappers}}.}

\item{...}{Other parameters that can be passed through to functions.}
}
\value{
A summary of the effect estimates can be obtained
with \code{summary} function.
}
\description{
The function \code{ce_estimate_tmle_ate} implements
TMLE to estimate ATE effect with
multiple treatments using observational data.
}
\references{
Hadley Wickham, Romain François, Lionel Henry and Kirill Müller (2021).
\emph{dplyr: A Grammar of Data Manipulation}.
R package version 1.0.7.
URL: \url{https://CRAN.R-project.org/package=dplyr}

Eric Polley, Erin LeDell, Chris Kennedy and Mark van der Laan (2021).
\emph{SuperLearner: Super Learner Prediction}.
R package version 2.0-28.
URL:\url{https://CRAN.R-project.org/package=SuperLearner}

Susan Gruber, Mark J. van der Laan (2012).
tmle: An R Package for Targeted Maximum Likelihood Estimation.
 \emph{Journal of Statistical Software}, \strong{51}(13), 1-35.
}
